close all
clear all
clc

tic;

%% Call folders
folder_source = 'C:\Users\TU Delf SID\Documents\PhD ANCE\Taxibot';
folder_dest = folder_source; % Temporarily save in same folder
file_name = 'L1_R1_F1_12-00_taxibot.tdms';
file_path = fullfile(folder_source,file_name);
file_name_new = 'Try_L1_R1_F1_12-00'; % Name of Matlab file

%% Read the TDMS file
[finalOutput,metaStruct] = TDMS_readTDMSFile(file_path);
data_length = length(finalOutput.data{3});

data = zeros(112,data_length); % initialize the data vector
for i = 1:112 % i = channel number
    data(i,:) = finalOutput.data{i+2};
end

% save(fullfile(folder_dest, [file_name_new, '.mat']))
toc

%% Analysis time domain
fs = 48000;
dt = 1/fs;
N = data_length;
t = 0:dt:(N-1)*dt;
mic = 1; % Look at first channel/first mic

figure
plot(t,data(mic,:))
xlabel('Time [s]')
ylabel('Pressure [Pa]')

%% Analysis frequency domain - copied from Roberto's main file
df      = 10; % Chosen by Roberto, but why?
nfft    = pow2(nextpow2(fs/df));
window  = hann(nfft);
overlap = nfft/2;
pref    = 2e-5;
[Pxx,f] = pwelch(data(mic,:),window,overlap,nfft,fs);

% PSD
figure
semilogx(f,10*log10(Pxx/(pref)^2));
xlabel('f [Hz]')
ylabel('PSD [dB/Hz]')

% SPL RMS - shouldn't this be OSPL because it is over the full data and not
% for a specific frequency?
SPL_rms = 20*log10(rms(data(mic,:))/pref);
disp(['The SPL RMS measured by microphone ' num2str(mic) ' is ' num2str(SPL_rms) ' dB'])

% OASPL - for comparison with the dB meter used at Schiphol, only at 0.05
% sec around maximum pressure
select = 23.95*fs:24.0*fs;
nfft    = pow2(nextpow2(length(select)));
window  = hann(length(select)); %Hanning window should not include the size of zero-padding
overlap = nfft/2;
[Pxx_select,f] = pwelch(data(mic,select),window,overlap,nfft,fs); %Pxx_select is the PSD
df_pwelch = f(3)-f(2);

SPL = 10*log10(Pxx_select*df_pwelch/(pref^2)); 
for freq = 1:length(f)
    A_cor(freq) = -145.528 + 98.262*log10(f(freq)) - 19.509*(log10(f(freq)))^2 + 0.975*(log10(f(freq)))^3;
end
SPL_A_cor = SPL_dB + A_cor;
OASPL = 10*log10(sum(10.^(SPL_A_cor./10)));

disp(['The OASPL measured by microphone ' num2str(mic) ' is ' num2str(OASPL) ' dBA'])
% OASPL at highest point is 112.6964 dBA. This is definitely not what is
% measured at the array (74.3 dBA), so perhaps this includes the distance
% correction already?

hann_window = hann(length(select));
X_hann = data(mic,select).*hann_window';
df = fs/nfft;
freq = 0:df:(nfft/2-1)*df;
Xdft = fft(X_hann,nfft,2);
Xdft = sqrt(2)*Xdft(:,1:length(freq))/sqrt(sum(hann_window.^2));
PSD = (abs(Xdft)).^2/(fs);

% Check if pwelch == PSD
figure
semilogx(f,10*log10(Pxx_select/(pref^2)))
hold on
semilogx(freq,10*log10(PSD/(pref^2)))

OSPL_t = 10*log10(var(data(mic,select))/pref^2);   % from time domain
OSPL_f = 10*log10(df*sum(PSD)/pref^2);     % from frequency domain

